function PrintContriRotSymmeCoord(rotation,labels_r,labels_c);
%prints contributions after ortohgonal rotation of symmetrical coordinates
%
%       rotation      The 'rotation' structure generated by ComputeRotation.m
%       labels_r      Row labels
%       labels_c      Column labels
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

      if ischar(labels_r),
         str_r=cellstr(labels_r);
      else,
         str_r=labels_r;
      end;
      
      if ischar(labels_c),
         str_c=cellstr(labels_c);
      else,
         str_c=labels_c;
      end;
      
      [m,tmp]=size(str_r);
      if tmp>m, m=tmp;end;
  	  s1=0;
		  for i=1:m,
          if s1 < length(str_r{i}),
             s1= length(str_r{i});
          end;
	  end;
      
      [m,tmp]=size(str_c);
      if tmp>m, m=tmp;end;
	  s2=0;
		  for i=1:m,
          if s2 < length(str_c{i}),
             s2= length(str_c{i});
          end;
	  end;
      s=max(s1,s2);
	  if s>30, s=30;end;
	  if s<5 , s=5;end;
      
      [sr,k]=size(rotation.ARSCT);
      
	  form=sprintf('%%-%d.%ds        Overall Indices          Dimensions',s,s);   
	  buff=sprintf(form,'Value');   
      disp(buff);    
	  form=sprintf('%%-%d.%ds                                 ',s,s);   
	  buff=sprintf(form,' ');   
      for i=1:k,
          buff1=sprintf('%-3.0f                     ',i);
          buff=[buff buff1];
      end;
      disp(buff);              
	  form=sprintf('%%-%d.%ds------- ------------------------ ',s,s);   
	  buff=sprintf(form,'---------------------------------------------------------------------------------');   
      for i=1:k,
          buff=[buff '----------------------- '];
      end;
      disp(buff);    
	  form=sprintf('%%-%d.%ds        inr      inr%%%%     qlt    ',s,s);   
	  buff=sprintf(form,' ');   
      for i=1:k,
          buff=[buff ' cor     scor    ctr    '];
      end;
      disp(buff);    

      disp(' ');
     
		  form=sprintf('%%-%d.%ds        ',s,s);   
      for i=1:sr,
	        buff1=sprintf(form,char(str_r(i)));   
            buff2=sprintf('%5.3f    %4.3f     --    ',rotation.INSR(i,1),rotation.INSR(i,2));
            buff3=[];
            for j=1:k,
               buff4=sprintf('  --      --     %4.3f  ',rotation.ARSCT(i,j));
               buff3=[buff3 buff4];
            end;
            disp([buff1 buff2 buff3]);          
            
      end;
      disp(' ');
      
		  form=sprintf('%%-%d.%ds        ',s,s);   
      [sc,k]=size(rotation.ACSCT);
      for i=1:sc,
	        buff1=sprintf(form,char(str_c(i)));   
            buff2=sprintf('%5.3f    %4.3f     --    ',rotation.INSC(i,1),rotation.INSC(i,2));
            buff3=[];
            for j=1:k,
                buff4=sprintf('  --      --     %4.3f  ',rotation.ACSCT(i,j));
                buff3=[buff3 buff4];
            end;
            disp([buff1 buff2 buff3]);          
            
      end;
      disp(' ');

	  form=sprintf('%%-%d.%ds---------------------------------',s,s);   
	  buff=sprintf(form,'------------------------------------------------------------------------------------');   
      for i=1:k,
          buff=[buff '------------------------'];
      end;
      disp(buff);    
      disp(' ');
      disp('inr:  Inertia of each row and column; inr%: Percentage of inertia of each row and column;');
      disp('qlt:  Total quality with respect to the dimensionality of the solution;');
      disp('cor:  Correlations of rows and columns with axes (similar to component loadings in PCA);');
      disp('scor: Contributions of axes to points (squared correlations of points with axes);');
      disp('ctr:  Contributions of points to axes');
      disp(' ');

return;
