function PrintContributions(output,k);
%prints (rows or columns) contributions to principal (or symmetrical) inertias
%
%       output      The 'output' structure generated by CAnalysis.m
%
%       k           Number of dimensions to retain
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

      if ischar(output.labels.r),
         str_r=cellstr(output.labels.r);
      else,
         str_r=output.labels.r;
      end;
      
      if ischar(output.labels.c),
         str_c=cellstr(output.labels.c);
      else,
         str_c=output.labels.c;
      end;
      
      [m,tmp]=size(output.INr);
	  s1=0;
		  for i=1:m,
          if s1 < length(str_r{i}),
             s1= length(str_r{i});
          end;
	  end;
      
      [m,tmp]=size(output.INc);
	  s2=0;
		  for i=1:m,
          if s2 < length(str_c{i}),
             s2= length(str_c{i});
          end;
	  end;
      s=max(s1,s2);
      
	  if s>30, s=30;end;
	  if s<5 , s=5;end;
	  form=sprintf('%%-%d.%ds        Overall Indices          Dimensions',s,s);   
	  buff=sprintf(form,'Value');   
      disp(buff);    
	  form=sprintf('%%-%d.%ds                                 ',s,s);   
	  buff=sprintf(form,' ');   
      for i=1:k,
          buff1=sprintf('%-3.0f                     ',i);
          buff=[buff buff1];
      end;
      disp(buff);              
	  form=sprintf('%%-%d.%ds------- ------------------------ ',s,s);   
	  buff=sprintf(form,'---------------------------------------------------------------------------------');   
      for i=1:k,
          buff=[buff '----------------------- '];
      end;
      disp(buff);    
	  form=sprintf('%%-%d.%ds        inr      inr%%%%     qlt    ',s,s);   
	  buff=sprintf(form,' ');   
      for i=1:k,
          buff=[buff ' cor     scor    ctr    '];
      end;
      disp(buff);    

      disp(' ');
     
		  form=sprintf('%%-%d.%ds        ',s,s);   
      for i=1:output.I,
	        buff1=sprintf(form,char(str_r(i)));   
            buff2=sprintf('%5.3f    %4.3f   % 4.3f  ',output.INr(i,1),output.INr(i,2),output.QLTr(i));
            buff3=[];
            for j=1:k,
                buff4=sprintf('% 4.3f   %4.3f   %4.3f  ',output.Br(i,j),output.RRC(i,j),output.ARC(i,j));
                buff3=[buff3 buff4];
            end;
            disp([buff1 buff2 buff3]);          
            
      end;
      disp(' ');
      
		  form=sprintf('%%-%d.%ds        ',s,s);   
      for i=1:output.J,
	        buff1=sprintf(form,char(str_c(i)));   
            buff2=sprintf('%5.3f    %4.3f   % 4.3f  ',output.INc(i,1),output.INc(i,2),output.QLTc(i));
            buff3=[];
            for j=1:k,
                buff4=sprintf('% 4.3f   %4.3f   %4.3f  ',output.Bc(i,j),output.RCC(i,j),output.ACC(i,j));
                buff3=[buff3 buff4];
            end;
            disp([buff1 buff2 buff3]);          
            
      end;
      disp(' ');

	  form=sprintf('%%-%d.%ds---------------------------------',s,s);   
	  buff=sprintf(form,'------------------------------------------------------------------------------------');   
      for i=1:k,
          buff=[buff '------------------------'];
      end;
      disp(buff);    
      disp(' ');
      disp('inr:  Inertia of each row and column; inr%: Percentage of inertia of each row and column;');
      disp('qlt:  Total quality with respect to the dimensionality of the solution;');
      disp('cor:  Correlations of rows and columns with axes (similar to component loadings in PCA);');
      disp('scor: Contributions of axes to points (squared correlations of points with axes);');
      disp('ctr:  Contributions of points to axes');
      disp(' ');

return;
