function PrintCoordinates(output,k,coordinates,detailed);
%prints the descriptives in the 'output' generated by CAnalysis.m
%
% INPUT
%       output      The 'output' structure generated by CAnalysis.m
%
%       k           Number of dimensions to retain
%
%       coordinates 1 -> Symmetrical coordinates (biplot model)
%                   2 -> Row principal coordinates, and column standard coordinates
%                   3 -> Column principal coordinates, and row standard coordinates
%                   4 -> Row and Column principal coordinates (French classical model)
%
%       detailed    1 -> Prints all the details
%                   0 -> Prints the basic information
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

disp('-------------------------------------------------------------------------');

switch coordinates
% 1 -> Symmetrical coordinates (biplot)
  case 1
    disp(' ');
    disp('Model: Symmetrical coordinates (biplot model)');
    disp(' ');
    disp(' ');
    disp('Row coordinates');
    disp(' ');
    PrintMatrixOfCoordinates(output.H,output.labels.r,k);    
    disp(' ');
    disp(' ');
    disp('Column coordinates');
    disp(' ');
    PrintMatrixOfCoordinates(output.Z,output.labels.c,k);    
    disp(' ');
    
% 2 -> Row principal coordinates, and column standard coordinates
  case 2
    disp(' ');
    disp('Model: Row principal coordinates, and column standard coordinates');
    disp(' ');
    disp(' ');
    
    disp('Row principal coordinates');
    disp(' ');
    PrintMatrixOfCoordinates(output.F,output.labels.r,k);    
    disp(' ');
    disp(' ');   
    disp('Column standard coordinates');
    disp(' ');
    PrintMatrixOfCoordinates(output.Y,output.labels.c,k);    
    disp(' ');

      
% 3 -> Column principal coordinates, and rows standard coordinates
  case 3
    disp(' ');
    disp('Model: Column principal coordinates, and rows standard coordinates');
    disp(' ');
    disp(' ');
    disp('Column principal coordinates');
    disp(' ');
    PrintMatrixOfCoordinates(output.G,output.labels.c,k);    
    disp(' ');
    disp(' ');
    disp('Row standard coordinates');
    disp(' ');
    PrintMatrixOfCoordinates(output.X,output.labels.r,k);    
    disp(' ');

% 4 -> Rows and Column principal coordinates (French model)
  case 4
    disp(' ');
    disp('Model: Row and Column principal coordinates (French symmetrical model)');
    disp(' ');
    disp(' ');
    disp('Row principal coordinates');
    disp(' ');
    PrintMatrixOfCoordinates(output.F,output.labels.r,k);    
    disp(' ');
    disp(' ');
    disp('Column principal coordinates');
    disp(' ');
    PrintMatrixOfCoordinates(output.G,output.labels.c,k);    
    disp(' ');
    disp(' ');

    
  otherwise

    return;
  

end;

%Supplementary row points
if isfield(output,'Xsup'),
    disp(' ');
    disp('Supplementary row coordinates');
    disp(' ');
	switch coordinates
        
	% 1 -> Symmetrical coordinates (biplot)
      case 1
          PrintMatrixOfCoordinates(output.Hsup,output.labels.sr,k);  
        
	% 2 -> Row principal coordinates, and column standard coordinates
      case 2
          PrintMatrixOfCoordinates(output.Fsup,output.labels.sr,k);  
	% 3 -> Column principal coordinates, and rows standard coordinates
      case 3
          PrintMatrixOfCoordinates(output.Xsup,output.labels.sr,k);  
    % 4 -> Row and Column principal coordinates (French model)
      case 4
          PrintMatrixOfCoordinates(output.Fsup,output.labels.sr,k);  
          
	end;
    disp(' ');
end;

%Supplementary column points
if isfield(output,'Ysup'),
    disp(' ');
    disp('Supplementary column coordinates');
    disp(' ');
	switch coordinates
        
	% 1 -> Symmetrical coordinates (biplot)
      case 1
          PrintMatrixOfCoordinates(output.Zsup,output.labels.sc,k);  
        
	% 2 -> Row principal coordinates, and column standard coordinates
      case 2
          PrintMatrixOfCoordinates(output.Ysup,output.labels.sc,k);  
	% 3 -> Column principal coordinates, and rows standard coordinates
      case 3
          PrintMatrixOfCoordinates(output.Gsup,output.labels.sc,k);  
    % 4 -> Row and Column principal coordinates (French model)
      case 4
          PrintMatrixOfCoordinates(output.Gsup,output.labels.sr,k);  
	end;
    disp(' ');
end;

disp('-------------------------------------------------------------------------');

if detailed == 1,
   disp(' ');
   
	switch coordinates
	% 1 -> Symmetrical coordinates (biplot)
      case 1
       disp('Diagnostics: Contributions of rows and columns to symmetrical axes');   
       disp(' ');
       disp(' ');
        
	% 2 -> Row principal coordinates, and column standard coordinates
      case 2
       disp('Diagnostics: Contributions of rows and columns to axes');   
       disp(' ');
       disp(' ');
       
	% 3 -> Column principal coordinates, and rows standard coordinates
      case 3
       disp('Diagnostics: Contributions of rows and columns to axes');   
       disp(' ');
       disp(' ');

    % 4 -> Row and Column principal coordinates (French model)
      case 4
       disp('Diagnostics: Contributions of rows and columns to axes');   
       disp(' ');
       disp(' ');
	
      otherwise
	
        return;
      
	end;   
   
    PrintContributions(output,k);
    disp('-------------------------------------------------------------------------');
    disp(' ');
   
end;


return;