function PrintDescriptives(output,detailed);
%prints the descriptives in the 'output' generated by CAnalysis.m
%
% INPUT
%       output      The 'output' structure generated by CAnalysis.m
%       detailed    1 -> Prints all the details
%                   0 -> Prints the basic information
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%Crosstabulation matrix
disp(' ');
me.str=sprintf('The %.0f x %.0f crosstabulation table',output.I,output.J);
disp(me.str);
disp(' ');
CrossTabulateLabels(output.N, output.labels.r, output.labels.c);
disp(' ');
disp(' ');

if isfield(output,'SupRow'),
	disp('Crosstabulation table related to supplementary columns');
	disp(' ');
	CrossTabulateLabels(output.SupRow, output.labels.sr, output.labels.c);
	disp(' ');
	disp(' ');       
end;

if isfield(output,'SupCol'),
	disp('Crosstabulation table related to supplementary columns');
	disp(' ');
	CrossTabulateLabels(output.SupCol, output.labels.r, output.labels.sc);
	disp(' ');
	disp(' ');       
end;

if detailed == 1,
   %Row and columns sums & masses
   disp('-------------------------------------------------------------------------');
   disp(' ');
   disp('Row descriptives');
   disp(' ');
   PrintMasses(output.N',output.labels.r);
   disp(' ');
   disp(' ');
   disp('Row profiles');
   disp(' ');
   CrossTabulateLabels(output.RP, output.labels.r, output.labels.c);
   disp(' ');
   disp(' ');
   disp('-------------------------------------------------------------------------');
   disp(' ');
   disp(' ');
   disp('Column descriptives');
   disp(' ');
   PrintMasses(output.N,output.labels.c);
   disp(' ');
   disp(' ');
   disp('Column profiles');
   disp(' ');
   CrossTabulateLabels(output.CP, output.labels.r, output.labels.c);
   disp(' ');
   disp(' ');
   %Matrix of standardized residuals
   disp('-------------------------------------------------------------------------');
   disp(' ');
   disp(' ');
   disp('Standardized residuals');
   disp(' ');
   CrossTabulateLabels(output.A, output.labels.r, output.labels.c);
   disp(' ');
   
end;

disp('-------------------------------------------------------------------------');
disp(' ');
disp(' ');
disp('Indices of association ');
disp(' ');
buff =sprintf('Dimensions    = %.0f',output.K);
disp(buff);
buff =sprintf('Chi-square    = %.5f',output.chis);
disp(buff);
buff =sprintf('Total inertia = %.5f',output.ti);
disp(buff);
buff =sprintf('Cramer`s V    = %.5f',output.CV);
disp(buff);
disp(' ');

disp('-------------------------------------------------------------------------');
disp(' ');
disp(' ');
disp('Principal inertias (eigenvalues)');
disp(' ');
PrintPrincipalInertias(output.eig)
disp(' ');
disp(' ');
buff=sprintf('Average explained variance: %6.1f%% (dimensions explaining less variance should be excluded from the map; equivalent to Kaiser''s One-eigenvalue rule in EFA)',output.aev);
disp(buff);
disp(' ');
disp(' ');

return;