function PrintMasses(N,L);
%prints the (row or column) masses
%
%INPUT  N -> PrintMasses(N',L); prints row masses
%            PrintMasses(N,L); prints column masses
%       L    (Row or Column) labels
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if ischar(L),
    str=cellstr(L);
else,
    str=L;
end;

f = sum(N)';
[k,tmp]=size(f);
[kl,tmp]=size(str);
 kl = max([kl;tmp]);
     
if k~=kl,
    msgbox('Labels do not match with the tabulate data','CAR: Correspondence analysis with rotations','error');
    return;
end;

s=0;
for i=1:kl,
    if s < length(str{i}),
        s= length(str{i});
    end;
end;
if s>30, s=30;end;
if s<5 , s=5;end;

f=[f f/sum(f)];

form=sprintf('%%-%d.%ds        Sum    Masses',s,s);   
buff=sprintf(form,'Value');   
disp(buff);    
disp(' ');
for i=1:k,
    form=sprintf('%%-%d.%ds %%10.0f    %%6.4f%%',s,s);   
    buff=sprintf(form,str{i},f(i,1),f(i,2));   
    disp(buff)    
end;
