function PrintMatrixOfCoordinates(A,L,k);
%prints the (row or column) coordinates
%
%INPUT  A    Matrix of coordinates to be printed
%       L    Labels related to A
%       k    Number of dimensions to report
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if ischar(L),
    str=cellstr(L);
else,
    str=L;
end;

[m,tmp]=size(A);
[ml,tmp]=size(str);
 ml = max([ml;tmp]);
     
if m~=ml,
    msgbox('Labels do not match with the matrix of coordinates','CAR: Correspondence analysis with rotations','error');
    return;
end;

s=0;
for i=1:ml,
    if s < length(str{i}),
        s= length(str{i});
    end;
end;
if s>30, s=30;end;
if s<5 , s=5;end;

form=sprintf('%%-%d.%ds        Dimensions',s,s);   
buff=sprintf(form,'Value');   
disp(buff);  
disp(' ');
form=sprintf('%%-%d.%ds          ',s,s);   
buff=sprintf(form,'     ');
for i=1:k,
    buff2=sprintf('%-5.0f      ',i);
    buff = [buff buff2];
end;
disp(buff);    
disp(' ');
for i=1:m,
    form=sprintf('%%-%d.%ds        ',s,s);   
    buff=sprintf(form,str{i});
    for j=1:k,
        buff2=sprintf('% 7.3f    ',A(i,j));
        buff=[buff buff2];
    end;
    disp(buff);
end;
