function PrintMatrixOfRotatedCoordinates(A,L,simp);
%prints the (row or column) rotated coordinates
%
%INPUT  A       Matrix of coordinates to be printed
%       L       Labels related to A
%       simp    0 -> the whole matrix is printed
%               1 -> Only salient calues are printed
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if ischar(L),
    str=cellstr(L);
else,
    str=L;
end;

[m,k]=size(A);
[ml,tmp]=size(str);
 ml = max([ml;tmp]);
     
if m~=ml,
    msgbox('Labels do not match with the matrix of coordinates','CAR: Correspondence analysis with rotations','error');
    return;
end;

s=0;
for i=1:ml,
    if s < length(str{i}),
        s= length(str{i});
    end;
end;
if s>30, s=30;end;
if s<5 , s=5;end;

trshold = mean(A.*A);

form=sprintf('%%-%d.%ds        Dimensions',s,s);   
buff=sprintf(form,'Value');   
disp(buff);   
disp(' ');
form=sprintf('%%-%d.%ds          ',s,s);   
buff=sprintf(form,'     ');
for i=1:k,
    buff2=sprintf('%-5.0f      ',i);
    buff = [buff buff2];
end;
disp(buff);    
disp(' ');
for i=1:m,
    form=sprintf('%%-%d.%ds        ',s,s);   
    buff=sprintf(form,str{i});
    for j=1:k,
        if simp == 1,
            if trshold(j)< A(i,j)*A(i,j),
                buff2=sprintf('% 7.3f    ',A(i,j));                            
            else,
                buff2='           ';
            end;
            
        else,
            buff2=sprintf('% 7.3f    ',A(i,j));            
        end;
        buff=[buff buff2];
    end;
    disp(buff);
end;
