function PrintPhi(phi);
%prints the inter-dimension correlation matrix
%
%INPUT  phi    Matrix of inter-dimensions correlation matrix
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[k,k]=size(phi);

buff='Dimensions     ';
for i=1:k,
    buff2=sprintf('%3.0f       ',i);
    buff = [buff buff2];
end;
disp(buff);    
disp(' ');
for i=1:k,
    buff=sprintf('%3.0f             ',i);
    for j=1:i,
        buff2=sprintf('% 5.3f    ',phi(i,j));
        buff=[buff buff2];
    end;
    disp(buff);
end;
