function PrintPrincipalInertias(CAeig);
%prints the principal inertias
%
%INPUT  CAeig Principla inertias stored in output.eig after executing CAnalysis
%       
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

f=CAeig;
[k,tmp]=size(f);

disp('Dim      Value       %      Cum%   Scree plot');
disp(' ');
for i=1:k,
    buff1=sprintf('%3.0f     %6.4f  %6.1f    ',i,f(i,1),f(i,2)*100);   
    buff2=sprintf('%6.1f   ',f(i,3)*100);   
    ast=floor(f(i,2)/max(f(:,2))*40);
    if f(i,2) > 0.01,
        buff3='*';
        for j=1:ast,
            buff3=[buff3 '*'];
        end;
    else,
        buff3='*';
    end;
    buff4 = sprintf('%s%s%s',buff1,buff2,buff3);
    disp(buff4);    
end;

disp('        ------  ------');   
buff=sprintf('Total:  %6.4f  %6.1f    ',sum(f(:,1)),sum(f(:,2)*100));   
disp(buff);
