function PrintRotation(rotation, method, weights, labels, detailed);
%Rotates the CA solution generated by CAnalysis.m
%
% INPUT
%       rotation   The 'rotation' structure generated by ComputeRotation.m
%
%       method      1 -> Orthogonal rotation of symmetrical coordinates
%                   2 -> Oblique rotation of symmetrical coordinates
%                   3 -> Orthogonal rotation of principal coordinates
%                   4 -> Orthogonal rotation of standard coordinates
%                   5 -> Oblique rotation of principal coordinates
%
%       weights     1 -> Row-wise normalization of coordinates
%                   2 -> To rescale coordinates using masses
%                   3 -> None. No weights scheme is used.
%
%       labels      Struture 'output.labels' generated by CAnalysis.m 
%
%       detailed    1 -> Prints all the details
%                   0 -> Prints the basic information
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
disp(' ');
disp('ROTATION  OF  COORDINATES  TO  MAXIMIZE  SIMPLICITY');
disp(' ');

%weights scheme
switch weights
%row wise normalization
case 1
    disp('Weights scheme used: Row-wise normalization. All the rows have the same influence on the final position of the axes.');
    disp(' ');
%weight for masses
case 2
    disp('Weights scheme used: Weight for masses. Infrequently observed points have the low influence on the final position of the axes.');
    disp(' ');
%raw
otherwise
    disp('Weights scheme used: None.');
    disp(' ');
end;

switch method
% 1 -> Orthogonal rotation of symmetrical coordinates
case 1
    disp('Rotation method: Varimax orthogonal rotation of symmetrical coordinates.');
    disp(' ');
    disp(' ');
    PrintBentlerSimplicity(rotation.bentler);
    disp(' ');
    disp(' ');
    disp('Rotated row coordinates');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.X_p,labels.r,0);
    disp(' ');
    disp(' ');
    disp('Rotated column coordinates');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.Y_p,labels.c,0);
    disp(' ');
    disp(' ');
    if isfield(rotation,'X_sup_p'),
        disp('Rotated supplementary row coordinates');
        disp(' ');
        PrintMatrixOfRotatedCoordinates(rotation.X_sup_p,labels.sr,0);
        disp(' ');
        disp(' ');        
    end;
    if isfield(rotation,'Y_sup_p'),
        disp('Rotated supplementary column coordinates');
        disp(' ');
        PrintMatrixOfRotatedCoordinates(rotation.Y_sup_p,labels.sc,0);
        disp(' ');
        disp(' ');        
    end;
    disp('Rotated row coordinates (only salient values are printed)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.X_p,labels.r,1);
    disp(' ');
    disp(' ');
    disp('Rotated column coordinates (only salient values are printed)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.Y_p,labels.c,1);
    disp(' ');
    disp(' ');
    
% 2 -> Oblique rotation of symmetrical coordinates
case 2
    disp('Rotation method: Quartimin oblique rotation of symmetrical coordinates.');
    disp(' ');
    disp(' ');
    PrintBentlerSimplicity(rotation.bentler);
    disp(' ');
    disp(' ');
    disp('Rotated row coordinates (pattern matrix)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.X_p,labels.r,0);
    disp(' ');
    disp(' ');
    disp('Rotated column coordinates (pattern matrix)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.Y_p,labels.c,0);
    disp(' ');
    disp(' ');
    if isfield(rotation,'X_sup_p'),
        disp('Rotated supplementary row coordinates (pattern matrix)');
        disp(' ');
        PrintMatrixOfRotatedCoordinates(rotation.X_sup_p,labels.sr,0);
        disp(' ');
        disp(' ');        
    end;
    if isfield(rotation,'Y_sup_p'),
        disp('Rotated supplementary column coordinates (pattern matrix)');
        disp(' ');
        PrintMatrixOfRotatedCoordinates(rotation.Y_sup_p,labels.sc,0);
        disp(' ');
        disp(' ');        
    end;
    disp('Rotated row coordinates (pattern matrix; only salient values are printed)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.X_p,labels.r,1);
    disp(' ');
    disp(' ');
    disp('Rotated column coordinates (pattern matrix; only salient values are printed)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.Y_p,labels.c,1);
    disp(' ');
    disp(' ');
    disp('Inter-dimensions correlation matrix');
    disp(' ');
    PrintPhi(rotation.phi);
    disp(' ');
    disp(' ');

    if detailed == 1,
       disp(' ');
       disp('Rotated row coordinates (pseudo-structure matrix)');
       disp(' ');
       PrintMatrixOfRotatedCoordinates(rotation.X_ps,labels.r,0);
       disp(' ');
       disp(' ');
       disp('Rotated column coordinates (pseudo-structure matrix)');
       disp(' ');
       PrintMatrixOfRotatedCoordinates(rotation.Y_ps,labels.c,0);
       disp(' ');
       disp(' ');
        if isfield(rotation,'X_sup_ps'),
            disp('Rotated supplementary row coordinates (pseudo-structure matrix)');
            disp(' ');
            PrintMatrixOfRotatedCoordinates(rotation.X_sup_ps,labels.sr,0);
            disp(' ');
            disp(' ');        
        end;
        if isfield(rotation,'Y_sup_ps'),
            disp('Rotated supplementary column coordinates (pseudo-structure matrix)');
            disp(' ');
            PrintMatrixOfRotatedCoordinates(rotation.Y_sup_ps,labels.sc,0);
            disp(' ');
            disp(' ');        
        end;
       
    end;
    
% 3 -> Orthogonal rotation of principal coordinates
case 3
    disp('Rotation method: Varimax orthogonal rotation of principal coordinates.');
    disp(' ');
    disp(' ');
    PrintBentlerSimplicity(rotation.bentler);
    disp(' ');
    disp(' ');
    disp('Rotated row coordinates');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.X_p,labels.r,0);
    disp(' ');
    disp(' ');
    disp('Rotated column coordinates');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.Y_p,labels.c,0);
    disp(' ');
    disp(' ');
    if isfield(rotation,'X_sup_p'),
        disp('Rotated supplementary row coordinates');
        disp(' ');
        PrintMatrixOfRotatedCoordinates(rotation.X_sup_p,labels.sr,0);
        disp(' ');
        disp(' ');        
    end;
    if isfield(rotation,'Y_sup_p'),
        disp('Rotated supplementary column coordinates');
        disp(' ');
        PrintMatrixOfRotatedCoordinates(rotation.Y_sup_p,labels.sc,0);
        disp(' ');
        disp(' ');        
    end;
    disp('Rotated row coordinates (only salient values are printed)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.X_p,labels.r,1);
    disp(' ');
    disp(' ');
    disp('Rotated column coordinates (only salient values are printed)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.Y_p,labels.c,1);
    disp(' ');
    disp(' ');

% 4 -> Orthogonal rotation of standard coordinates
case 4
    disp('Rotation method: Varimax orthogonal rotation of standard coordinates.');
    disp(' ');
    disp(' ');
    PrintBentlerSimplicity(rotation.bentler);
    disp(' ');
    disp(' ');
    disp('Rotated row coordinates');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.X_p,labels.r,0);
    disp(' ');
    disp(' ');
    disp('Rotated column coordinates');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.Y_p,labels.c,0);
    disp(' ');
    disp(' ');
    if isfield(rotation,'X_sup_p'),
        disp('Rotated supplementary row coordinates');
        disp(' ');
        PrintMatrixOfRotatedCoordinates(rotation.X_sup_p,labels.sr,0);
        disp(' ');
        disp(' ');        
    end;
    if isfield(rotation,'Y_sup_p'),
        disp('Rotated supplementary column coordinates');
        disp(' ');
        PrintMatrixOfRotatedCoordinates(rotation.Y_sup_p,labels.sc,0);
        disp(' ');
        disp(' ');        
    end;
    disp('Rotated row coordinates (only salient values are printed)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.X_p,labels.r,1);
    disp(' ');
    disp(' ');
    disp('Rotated column coordinates (only salient values are printed)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.Y_p,labels.c,1);
    disp(' ');
    disp(' ');
    
% 5 -> Oblique rotation of principal coordinates
case 5
    disp('Rotation method: Quartimin oblique rotation of principal coordinates.');
    disp(' ');
    disp(' ');
    PrintBentlerSimplicity(rotation.bentler);
    disp(' ');
    disp(' ');
    disp('Rotated row coordinates (pattern matrix)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.X_p,labels.r,0);
    disp(' ');
    disp(' ');
    disp('Rotated column coordinates (pattern matrix)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.Y_p,labels.c,0);
    disp(' ');
    disp(' ');
    if isfield(rotation,'X_sup_p'),
        disp('Rotated supplementary row coordinates (pattern matrix)');
        disp(' ');
        PrintMatrixOfRotatedCoordinates(rotation.X_sup_p,labels.sr,0);
        disp(' ');
        disp(' ');        
    end;
    if isfield(rotation,'Y_sup_p'),
        disp('Rotated supplementary column coordinates (pattern matrix)');
        disp(' ');
        PrintMatrixOfRotatedCoordinates(rotation.Y_sup_p,labels.sc,0);
        disp(' ');
        disp(' ');        
    end;
    disp('Rotated row coordinates (pattern matrix; only salient values are printed)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.X_p,labels.r,1);
    disp(' ');
    disp(' ');
    disp('Rotated column coordinates (pattern matrix; only salient values are printed)');
    disp(' ');
    PrintMatrixOfRotatedCoordinates(rotation.Y_p,labels.c,1);
    disp(' ');
    disp(' ');
    disp('Inter-dimensions correlation matrix');
    disp(' ');
    PrintPhi(rotation.phi);
    disp(' ');
    disp(' ');

    if detailed == 1,
       if isfield(rotation,'X_s') == 1,
           disp(' ');
           disp('Rotated row coordinates (structure matrix)');
           disp(' ');
           PrintMatrixOfRotatedCoordinates(rotation.X_s,labels.r,0);
           disp(' ');
           disp(' ');
       end;
       if isfield(rotation,'Y_s') == 1,
           disp(' ');
           disp('Rotated column coordinates (structure matrix)');
           disp(' ');
           PrintMatrixOfRotatedCoordinates(rotation.Y_s,labels.c,0);
           disp(' ');
           disp(' ');
       end;
        if isfield(rotation,'X_sup_s'),
            disp('Rotated supplementary row coordinates (structure matrix)');
            disp(' ');
            PrintMatrixOfRotatedCoordinates(rotation.X_sup_s,labels.sr,0);
            disp(' ');
            disp(' ');        
        end;
        if isfield(rotation,'Y_sup_s'),
            disp('Rotated supplementary column coordinates (structure matrix)');
            disp(' ');
            PrintMatrixOfRotatedCoordinates(rotation.Y_sup_s,labels.sc,0);
            disp(' ');
            disp(' ');        
        end;
        
    end;
end;

disp('-------------------------------------------------------------------------');

if detailed == 1,
	%%%%% Diagnostics after rotation
	
	switch method
	% 1 -> Orthogonal rotation of symmetrical coordinates
	case 1
		disp(' '); 
		disp(' '); 
		disp('Diagnostics: Contributions of rotated coordinates'); 
		disp(' '); 
        PrintContriRotSymmeCoord(rotation,labels.r,labels.c);
        disp(' ');
        disp('-------------------------------------------------------------------------');
        disp(' ');
	% 2 -> Oblique rotation of symmetrical coordinates
	case 2
		%
		% no diagnostics can be computed
		%
  	% 3 -> Orthogonal rotation of principal coordinates
	case 3
		disp(' '); 
		disp(' '); 
		disp('Diagnostics: Contributions of rotated coordinates'); 
		disp(' '); 
        PrintContriRotPrincCoord(rotation,labels.r,labels.c);
        disp(' ');
        disp('-------------------------------------------------------------------------');
        disp(' ');
	% 4 -> Orthogonal rotation of standard coordinates
	case 4
		disp(' '); 
		disp(' '); 
		disp('Diagnostics: Contributions of rotated coordinates'); 
		disp(' '); 
        PrintContriRotStandCoord(rotation,labels.r,labels.c);
        disp(' ');
        disp('-------------------------------------------------------------------------');
        disp(' ');
        
	% 5 -> Oblique rotation of principal coordinates
	case 5
		%
		% no diagnostics can be computed
		%
        
	end;

end;