function TabulateLabels(X,L);
%prints the data tabulated, and prints the tabulation with labels

if ischar(L),
    str=cellstr(L);
else,
    str=L;
end;

f = tabulate(X);
[k,tmp]=size(f);
[kl,tmp]=size(str);
 kl = max([kl;tmp]);
     
if k~=kl,
    msgbox('Labels do not match with the tabulate data','CAR: Correspondence analysis with rotations','error');
    return;
end;

s=0;
for i=1:kl,
    if s < length(str{i}),
        s= length(str{i});
    end;
end;
if s>30, s=30;end;
if s<9 , s=9;end;


form=sprintf('%%-%d.%ds  Count    Percent',s,s);   
buff=sprintf(form,'Value');   
disp(buff);    
for i=1:k,
    %Value    Count    Percent
    form=sprintf('%%-1.%ds %%6.0f    %%6.2f%%%%',s);   
    buff=sprintf(form,str{i},f(i,2),f(i,3));   
    disp(buff)    
end;
