function answer = ColumnSelector(varargin)
% COLUMNSELECTOR Application M-file for ColumnSelector.fig
%    FIG = COLUMNSELECTOR launch ColumnSelector GUI.
%    COLUMNSELECTOR('callback_name', ...) invoke the named callback.


% Last Modified by GUIDE v2.0 27-Oct-2008 21:47:16
error(nargchk(0,4,nargin)) % function takes only 0 or 4 argument
if nargin == 0 | isnumeric(varargin{1}) % LAUNCH GUI

	fig = openfig(mfilename,'reuse');

	% Use system color scheme for figure:
	set(fig,'Color',get(0,'defaultUicontrolBackgroundColor'));

	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
	guidata(fig, handles);

  % Position figure
    if nargin == 1
	   pos_size = get(fig,'Position');
	   pos = varargin{1};
	   if length(pos) ~= 2
		   error('Input argument must be a 2-element vector')
	   end
	   new_pos = [pos(1) pos(2) pos_size(3) pos_size(4)];
	   set(fig,'Position',new_pos,'Visible','on')
	   figure(fig)
    end
    
    %initialize indices
    indices = getappdata(0,'indices');
    set(handles.IndexRows,'str',num2str([1:indices.max]'));
    set(handles.IndexColumns,'str',num2str([1:indices.max]'));
    set(handles.IndexRows,'value',1);
    set(handles.IndexColumns,'value',2);
    
  % Wait for callbacks to run and window to be dismissed:
  uiwait(fig);

  % UIWAIT might have returned because the window was deleted using
  % the close box - in that case, return 'cancel' as the answer, and
  % don't bother deleting the window!
  if ~ishandle(fig)
	  answer = 'cancel';
  else
  	  % otherwise, we got here because the user pushed one of the two buttons.
	  % retrieve the latest copy of the 'handles' struct, and return the answer.
	  % Also, we need to delete the window.
	  handles = guidata(fig);
      answer = handles.answer;
	  delete(fig);
  end

elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		if (nargout)
			[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
		else
			feval(varargin{:}); % FEVAL switchyard
		end
	catch
		disp(lasterr);
	end

end


% --------------------------------------------------------------------
function varargout = IndexRows_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = IndexColumns_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = OkButton_Callback(h, eventdata, handles, varargin)

    irows    = get(handles.IndexRows,'value');
    icolumns = get(handles.IndexColumns,'value');

    if irows == icolumns,
       msgbox('The same columns has been selected. Please select different columns of the matrix','CAR: Correspondence analysis with rotations','error');
       return;
    end; 

    indices = getappdata(0,'indices');
    indices.rows = irows;
    indices.columns = icolumns;
    setappdata(0,'indices',indices);
    handles.answer = 'ok';
    guidata(h, handles);
    uiresume(handles.ColumnSelector);

% --------------------------------------------------------------------
function varargout = CancelButton_Callback(h, eventdata, handles, varargin)
handles.answer = 'cancel';
guidata(h, handles);
uiresume(handles.ColumnSelector);

