function varargout = itd(varargin)
% ITD Application M-file for itd.fig
%    FIG = ITD launch itd GUI.
%    ITD('callback_name', ...) invoke the named callback.

% Last Modified by GUIDE v2.0 05-Sep-2008 23:40:13

if nargin == 0  % LAUNCH GUI

	fig = openfig(mfilename,'reuse');

	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
    guidata(fig, handles);

	if nargout > 0
		varargout{1} = fig;
	end

    
elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		if (nargout)
			[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
		else
			feval(varargin{:}); % FEVAL switchyard
		end
	catch
		disp(lasterr);
	end

end

% --------------------------------------------------------------------
function varargout = name_Callback(h, eventdata, handles, varargin)

% --------------------------------------------------------------------
function varargout = file_Callback(h, eventdata, handles, varargin)

% --------------------------------------------------------------------
function varargout = ok_Callback(h, eventdata, handles, varargin)

    if isempty(get(handles.name,'string')),
        msgbox('Please, enter the name of the variable to be created', 'CAR: Correspondence analysis with rotations','error');
        return
    end;

    if isempty(get(handles.file,'string')),
        msgbox('Please, select the file to be read', 'CAR: Correspondence analysis with rotations','error');
        return
    end;
    
    %MAKE THE VARIABLE GLOBAL
    str1 = {'global '};
    str2 = get(handles.name,'string');
    str3 = {';'};
    str4 = char(strcat(str1,str2,str3));
    evalin('base',str4);
    
    try 
        %LOAD THE VARIABLE
        str1 = {' = load('''};
        str2 = get(handles.file,'string');;
        str3 = {''');'};
        str4 = char(strcat(get(handles.name,'string'),str1,str2,str3));
        evalin('base',str4);
                
	catch
        str1 = {'clear '};
        str2 = get(handles.name,'string');
        str3 = {';'};
        str4 = char(strcat(str1,str2,str3));
        evalin('base',str4);
        msgbox(lasterr,'CAR: Correspondence analysis with rotations','error');
        return
	end
    delete(gcf);
    car
    return;

% --------------------------------------------------------------------
function varargout = cancel_Callback(h, eventdata, handles, varargin)
    
    delete(gcf);
    car
    return;

% --------------------------------------------------------------------
function varargout = Browse_Callback(h, eventdata, handles, varargin)

   [filename, pathname] = uigetfile({'*.txt'; '*.dat'}, 'Pick a TXT file');
    if isequal(filename,0)|isequal(pathname,0)
        msgbox('File not found','CAR: Correspondence analysis with rotations','error');
    else
       set(handles.file,'string',[pathname, filename]);
    end
 