function map(D1,D2,redraw);
    
output=getappdata(0,'output');

if isfield(output,'NO'),
    disp('Not output is ready for a map display');
    return;
end;

data=getappdata(0,'data');

labels_rows = output.labels.r;
labels_columns = output.labels.c;
k=output.k;
if k==1,k=2;end;

supple = 0;

switch (data.model.coordinates)
case 1
     CX = output.H;    
     CY = output.Z;
     if isfield(output,'Hsup'),
        supple = supple + 1;
        labels_supple_r  = output.labels.sr;
        CXS =output.Hsup;     
     end;
     if isfield(output,'Zsup'),
        supple = supple + 2;
        labels_supple_c  = output.labels.sc;
        CYS =output.Zsup;     
     end;
case 2
     CX = output.F;    
     CY = output.Y ;   
     if isfield(output,'Fsup'),
        supple = supple + 1;
        labels_supple_r  = output.labels.sr;
        CXS =output.Fsup;     
     end;
     if isfield(output,'Ysup'),
        supple = supple + 2;
        labels_supple_c  = output.labels.sc;
        CYS =output.Ysup;     
     end;
case 3
     CX = output.X;    
     CY = output.G;   
     if isfield(output,'Xsup'),
        supple = supple + 1;
        labels_supple_r  = output.labels.sr;
        CXS =output.Xsup;     
     end;
     if isfield(output,'Gsup'),
        supple = supple + 2;
        labels_supple_c  = output.labels.sc;
        CYS =output.Gsup;     
     end;
case 4
     CX = output.F;    
     CY = output.G;   
     if isfield(output,'Fsup'),
        supple = supple + 1;
        labels_supple_r  = output.labels.sr;
        CXS =output.Fsup;     
     end;
     if isfield(output,'Gsup'),
        supple = supple + 2;
        labels_supple_c  = output.labels.sc;
        CYS =output.Gsup;     
     end;
end;

if redraw == 0,
    hf=figure('menubar','none','toolbar','figure','NextPlot','Add');
    mapF.hf=hf;
else,
    mapF = getappdata(0,'map');
    hf=mapF.hf;
    close(hf);
    hf=figure('menubar','none','toolbar','figure','NextPlot','Add');
    mapF.hf=hf;
end;

%% COLORS
%
blue=[.17 .35 .53];
red=[.62 .09 .24];
green=[.09 .39 .31];
gray=[.80 .80 .80];
yellow=[.96 .90 .13];
white=[1 1 1];

%%CREATE FIGURE
%
%set(hf,'Color',white,'Resize','off','Name','MAP','NumberTitle','off','PaperType','a4','position',[184 50 772 548]);
switch (data.model.coordinates)
case 1
     set(hf,'Color',white,'Resize','off','Name','MAP (Biplot symmetrical model)','NumberTitle','off','PaperType','a4','position',[184 50 772 548]);
case 2
     set(hf,'Color',white,'Resize','off','Name','MAP (Row principal coordinates, and column standard coordinates)','NumberTitle','off','PaperType','a4','position',[184 50 772 548]);
case 3
     set(hf,'Color',white,'Resize','off','Name','MAP (Row standard coordinates, and column principal coordinates)','NumberTitle','off','PaperType','a4','position',[184 50 772 548]);
case 4
     set(hf,'Color',white,'Resize','off','Name','MAP (French symmetrical model)','NumberTitle','off','PaperType','a4','position',[184 50 772 548]);
end;

ha=axes;
mapF.ha=ha;

%% PLOT POINTS
switch supple
case 0
    plot(CX(:,D1),CX(:,D2),'b.',CY(:,D1),CY(:,D2),'rx');    
case 1
    plot(CX(:,D1),CX(:,D2),'b.',CY(:,D1),CY(:,D2),'rx',CXS(:,D1),CXS(:,D2),'y^');    
case 2
    plot(CX(:,D1),CX(:,D2),'b.',CY(:,D1),CY(:,D2),'rx',CYS(:,D1),CYS(:,D2),'g+');    
case 3
    plot(CX(:,D1),CX(:,D2),'b.',CY(:,D1),CY(:,D2),'rx',CXS(:,D1),CXS(:,D2),'y^',CYS(:,D1),CYS(:,D2),'g+');    
end;

%% RANGE OF AXIS
switch supple
case 0
	xmin=min([CX(:,D1);CY(:,D1)]);
	xmax=max([CX(:,D1);CY(:,D1)]);
	ymin=min([CX(:,D2);CY(:,D2)]);
	ymax=max([CX(:,D2);CY(:,D2)]);
case 1
	xmin=min([CX(:,D1);CY(:,D1);CXS(:,D1)]);
	xmax=max([CX(:,D1);CY(:,D1);CXS(:,D1)]);
	ymin=min([CX(:,D2);CY(:,D2);CXS(:,D2)]);
	ymax=max([CX(:,D2);CY(:,D2);CXS(:,D2)]);
case 2
	xmin=min([CX(:,D1);CY(:,D1);CYS(:,D1)]);
	xmax=max([CX(:,D1);CY(:,D1);CYS(:,D1)]);
	ymin=min([CX(:,D2);CY(:,D2);CYS(:,D2)]);
	ymax=max([CX(:,D2);CY(:,D2);CYS(:,D2)]);
case 3
	xmin=min([CX(:,D1);CY(:,D1);CXS(:,D1);CYS(:,D1)]);
	xmax=max([CX(:,D1);CY(:,D1);CXS(:,D1);CYS(:,D1)]);
	ymin=min([CX(:,D2);CY(:,D2);CXS(:,D2);CYS(:,D2)]);
	ymax=max([CX(:,D2);CY(:,D2);CXS(:,D2);CYS(:,D2)]);
end;

marg=0.1;
ax= (-xmin + xmax); xmin = xmin - ax*marg; xmax = xmax + ax*marg;
ay= (-ymin + ymax); ymin = ymin - ay*marg; ymax = ymax + ay*marg;
xmin=min([xmin;ymin]);ymin=xmin;
xmax=max([xmax;ymax]);ymax=xmax;
axis([xmin,xmax,ymin,ymax]);

%% INTERNAL AXES
%%
line([xmin xmax],[0 0],'Color', gray);
line([0 0],[ymin (ymax - ay*marg)],'Color', gray);

%% POINTS FOR LEGENDE
marg=0.005;
ht_L1=text(xmin,ymax-(ay*marg)/2,['{\fontsize{8} \bullet Row}'],'Color',blue);
ht_L2=text(xmin+(ay*0.15),ymax-(ay*marg)/2,['{\fontsize{8} \times Column}'],'Color',red);
switch supple
case 1
    ht_L3=text(xmin+(ay*0.30),ymax-(ay*marg)/2,['{\fontsize{8} ^ Supplementary Row}'],'Color',yellow);
case 2
    ht_L3=text(xmin+(ay*0.30),ymax-(ay*marg)/2,['{\fontsize{8} + Supplementary Column}'],'Color',green);
case 3
    ht_L3=text(xmin+(ay*0.30),ymax-(ay*marg)/2,['{\fontsize{8} ^ Supplementary Row}'],'Color',yellow);
    ht_L3=text(xmin+(ay*0.55),ymax-(ay*marg)/2,['{\fontsize{8} + Supplementary Column}'],'Color',green);
end;

%% ORIGEN
%text(0,0,['{\fontsize{14}+}']);

%SCALE 
%
line([(xmax-0.1) xmax],[ymin ymin],'Color', [0 0 0]);
line([(xmax-0.1) (xmax-0.1)],[ymin-0.01 ymin+0.01],'Color', [0 0 0]);
line([xmax xmax],[ymin-0.01 ymin+0.01],'Color', [0 0 0]);
ht_e1=text((xmax-0.08),ymin+0.05,'scale','FontName','times','FontSize',8,'FontAngle','Italic');
ht_e2=text((xmax-0.08),ymin-0.05,['{\fontsize{6} 0.1}']);

%%LABELS FOR POINTS
set(0,'DefaultAxesFontSize',10,'DefaultAxesFontName', 'Times');
text(CX(:,D1),CX(:,D2),labels_rows,'FontName', 'Times', 'FontSize', 8,'HorizontalAlignment','left','VerticalAlignment','baseline','Color',blue);
text(CY(:,D1),CY(:,D2),labels_columns,'FontName', 'Times', 'FontSize', 8,'HorizontalAlignment','right','VerticalAlignment','top','Color',red);
switch supple
case 1
    text(CXS(:,D1),CXS(:,D2),labels_supple_r,'FontName', 'Times', 'FontSize', 8,'HorizontalAlignment','right','VerticalAlignment','top','Color',yellow);
case 2
    text(CYS(:,D1),CYS(:,D2),labels_supple_c,'FontName', 'Times', 'FontSize', 8,'HorizontalAlignment','right','VerticalAlignment','top','Color',green);
case 3
    text(CXS(:,D1),CXS(:,D2),labels_supple_r,'FontName', 'Times', 'FontSize', 8,'HorizontalAlignment','right','VerticalAlignment','top','Color',yellow);
    text(CYS(:,D1),CYS(:,D2),labels_supple_c,'FontName', 'Times', 'FontSize', 8,'HorizontalAlignment','right','VerticalAlignment','top','Color',green);
end;

%%LABELS TO AXES
marg=0.1;
dim1=['Dimension ',sprintf('%2.0f',D1),' (',sprintf('%5.1f',output.eig(D1,2)*100),'%)'];
dim2=['Dimension ',sprintf('%2.0f',D2),' (',sprintf('%5.1f',output.eig(D2,2)*100),'%)'];
text(xmin-ay*0.05,0,dim1,'FontName', 'Times', 'FontSize', 8,'HorizontalAlignment','center','rotation',90);
text(0,ymax-(ay*marg)/2,dim2,'FontName', 'Times', 'FontSize', 8,'HorizontalAlignment','center');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%TITLE
switch (data.model.coordinates)
case 1
     title('Correspondence Analysis (Biplot symmetrical model)');
case 2
     title('Correspondence Analysis (Row principal coordinates, and column standard coordinates)');
case 3
     title('Correspondence Analysis (Row standard coordinates, and column principal coordinates)');
case 4
     title('Correspondence Analysis (French symmetrical model)');
end;

%% SOME FINAL FORMAT DEFINITION
%
set(ha,'visible','off');

%% Customize the  figure Toolbar
%
ChildrenOfFigure=allchild(hf);
FigureToolbar =ChildrenOfFigure(2);
ChildrenOfToolbar=allchild(FigureToolbar);
mapF.FigureToolbar = FigureToolbar;
mapF.ChildrenOfToolbar = ChildrenOfToolbar;

[chi,tmp]=size(ChildrenOfToolbar);
a=[.20:0.05:0.95];
img=rand(16,16,3);
img(:,:,1)=repmat(a,16,1);
img(:,:,2)=repmat(a,16,1);
img(:,:,1)=repmat(flipdim(a,2),16,1);
for i= 1:chi,
    str=get(ChildrenOfToolbar(i),'TooltipString');
    switch str
      case {'Rotate 3D','Open File','New Figure'}
          set(ChildrenOfToolbar(i),'visible','off')
      otherwise
          set(ChildrenOfToolbar(i),'HandleVisibility','off');
    end;
end;

if k<3, 
    setappdata(0,'map',mapF);
    return; 
end;

%New ToolBar
myToolBar = uitoolbar(hf);

img1=zeros(16,16,3);
img1(:,:,1)=[
.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	.95	.95	.95	.95	.95	0.00	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	.95	.95	.95	.95	0.00	0.00	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	.95	.95	.95	0.00	0.00	0.00	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	.95	.95	0.00	0.00	0.00	0.00	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	.95	0.00	0.00	0.00	0.00	0.00	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00	.95	.95	.95	.95	.95	.95
.95	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00	0.00	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	.95	0.00	0.00	0.00	0.00	0.00	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	.95	.95	0.00	0.00	0.00	0.00	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	.95	.95	.95	0.00	0.00	0.00	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	.95	.95	.95	.95	0.00	0.00	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	.95	.95	.95	.95	.95	0.00	.95	.95	.95	.95	.95	.95
.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95	.95
];
img1(:,:,2)=[
0.20	0.25	0.30	0.35	0.40	0.45	0.50	0.55	0.60	0.65	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.40	0.45	0.50	0.55	0.60	0.65	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.40	0.45	0.50	0.55	0.60	0.00	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.40	0.45	0.50	0.55	0.00	0.00	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.40	0.45	0.50	0.00	0.00	0.00	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.40	0.45	0.00	0.00	0.00	0.00	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.40	0.00	0.00	0.00	0.00	0.00	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.00	0.00	0.00	0.00	0.00	0.00	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.00	0.00	0.00	0.00	0.00	0.00	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.40	0.00	0.00	0.00	0.00	0.00	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.40	0.45	0.00	0.00	0.00	0.00	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.40	0.45	0.50	0.00	0.00	0.00	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.40	0.45	0.50	0.55	0.00	0.00	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.40	0.45	0.50	0.55	0.60	0.00	0.70	0.75	0.80	0.85	0.90	0.95
0.20	0.25	0.30	0.35	0.40	0.45	0.50	0.55	0.60	0.65	0.70	0.75	0.80	0.85	0.90	0.95];
img1(:,:,3)=[
0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	.95	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	0.00	0.00	0.00	.95	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	0.00	0.00	.95	.95	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	0.00	.95	.95	.95	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	.95	.95	.95	.95	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	.95	.95	.95	.95	.95	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	.95	.95	.95	.95	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	0.00	.95	.95	.95	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	0.00	0.00	.95	.95	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	0.00	0.00	0.00	.95	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	.95	.95	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	.95	0.00	0.00	0.00	0.00	0.00	0.00
0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00	0.00
];
img2=zeros(16,16,3);
img2(:,:,1)=flipdim(img1(:,:,1),2);
img2(:,:,2)=flipdim(img1(:,:,2),2);
img2(:,:,3)=flipdim(img1(:,:,3),2);
hbd=uipushtool(myToolBar,'CData',img1,'enable','off','visible','on','Separator','off','TooltipString','To change the dimensions presented in the graph','HandleVisibility','off');
hbi=uipushtool(myToolBar,'CData',img2,'enable','off','visible','on','Separator','off','TooltipString','To change the dimensions presented in the graph','HandleVisibility','off');

mapF.pairs = k*(k-1)/2;
if redraw == 0, 
   mapF.pos = 1;
end;
h=1;
mapF.seq=[];
for i=1:k-1,
    for j=i+1:k,
        mapF.seq=[mapF.seq; i j];
    end;
end;

if mapF.pos < mapF.pairs,
   cb=['mapF = getappdata(0,''map'');mapF.pos=mapF.pos+1;setappdata(0,''map'',mapF);map(', sprintf('%3.0f',mapF.seq(mapF.pos+1,1)),',', sprintf('%3.0f',mapF.seq(mapF.pos+1,2)),',1);clear mapF;'];
   set(hbi,'enable','on','ClickedCallback',cb,'TooltipString',['To show map of dimensions ' , sprintf('%3.0f',mapF.seq(mapF.pos+1,1)),' and ',sprintf('%3.0f',mapF.seq(mapF.pos+1,2))]); 
else,
   set(hbi,'enable','off'); 
end;
if mapF.pos > 1,
   cb=['mapF = getappdata(0,''map'');mapF.pos=mapF.pos-1;setappdata(0,''map'',mapF);map(', sprintf('%3.0f',mapF.seq(mapF.pos-1,1)),',', sprintf('%3.0f',mapF.seq(mapF.pos-1,2)),',1);clear mapF;'];
   set(hbd,'enable','on','ClickedCallback',cb,'TooltipString',['To show map of dimensions ' , sprintf('%3.0f',mapF.seq(mapF.pos-1,1)),' and ',sprintf('%3.0f',mapF.seq(mapF.pos-1,2))]); 
else,
   set(hbd,'enable','off');     
end;

%%%% Prepare for next enter
%
setappdata(0,'map',mapF);
