%This file contains editable Matlab code for general GP
%algorithms for rotation. See "http://www.stat.ucla.edu/research"
%for a discussion of these.
%------------------------------------------------------------
%Subroutine for the value and gradient of f for quartimin
%rotation.
%------------------------------------------------------------

function [f,G]=vgfQmin(B1,B2,T)

%rows
[p,k]=size(B1);
L=B1*inv(T)';
L2=L.^2;
N=ones(k,k)-eye(k);

f1=sum(sum(L2.*(L2*N)))/4;

Gq1=L.*(L2*N);
G1 =-(L'*Gq1*inv(T))';

%columns
[p,k]=size(B2);
L=B2*inv(T)';
L2=L.^2;
N=ones(k,k)-eye(k);

f2=sum(sum(L2.*(L2*N)))/4;

Gq2=L.*(L2*N);
G2=-(L'*Gq2*inv(T))';

%overall
G = 0.5*G1 + 0.5*G2;
f = 0.5*f1 + 0.5*f2;

return;
